#ifndef _BLOCKS_SKUNK_
#define _BLOCKS_SKUNK_
typedef struct Skunk Skunk;
#include "common.h"
#include "block.h"
#include "game.h"
#include "main.h"
#include "dialog.h"
struct Skunk {
    Block super;
    LandArray * stack;
    int step;
    int direction;
    int want_direction;
    int rotstep;
    bool pull /* jump key pressed with no direction keys pressed */;
    bool reverse /* started moving in backwards direction */;
    bool pushing;
    bool dead;
    bool lever;
    bool metal;
    int accel;
};
Block* player_allocate(void);
void player_init(Block * super);
void player_destroy(Block * super);
void player_try_pull(Skunk * self, float px, float pz);
void player_grab(Skunk * self);
void player_lift(Skunk * self);
void player_tick(Block * super);
bool player_touch(Block * super, Block * c, float dx, float dy, float dz);
bool have_friend(void);
void avoid_collision(Block * b);
void player_find_entrance(void);
#endif
